// debug-runner.js — runs even if popup.js failed parsing/execution
(function(){
  try {
    const debugEl = document.getElementById('popupDebug');
    if (!debugEl) return;

    // If popup.js set this flag then it ran
    if (window.__popupInitExecuted === true) {
      debugEl.textContent = 'popup.js executed (flag) — OK';
      debugEl.className = 'status success';
      return;
    }

    // Check for presence of known functions
    if (typeof initPopup === 'function') {
      debugEl.textContent = 'initPopup() present — running it now';
      debugEl.className = 'status info';
      try { initPopup(); } catch (e) { debugEl.textContent = 'initPopup threw: ' + (e && e.message); debugEl.className='status error'; }
      return;
    }

    // If neither flag nor initPopup exist, likely parse error in popup.js
    debugEl.textContent = 'popup.js did NOT run (possible syntax error)';
    debugEl.className = 'status error';
  } catch (err) {
    try {
      document.getElementById('popupDebug').textContent = 'debug-runner error: ' + (err && err.message);
    } catch (e) {}
  }
})();